/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareUtils {
    public static final int compareIntNumbers(Number number, Number number2) {
        return CompareUtils.compareLong(number.longValue(), number2.longValue());
    }

    public static final int compareInt(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    public static final int compareLong(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public static final <T> Comparator<T> createComparator(final List<? extends Comparator<T>> list) {
        return new Comparator<T>(){

            public String toString() {
                return "CompareUtils comparator with " + list;
            }

            @Override
            public int compare(T t, T t2) {
                int n = 0;
                for (int i = 0; i < list.size() && n == 0; ++i) {
                    Comparator comparator = (Comparator)list.get(i);
                    n = comparator.compare(t, t2);
                }
                return n;
            }
        };
    }

    public static final boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }
}

