/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;

public class ODTPrinter
implements Printable {
    protected ODTRenderer renderer;

    public ODTPrinter(OpenDocument openDocument) {
        this.renderer = new ODTRenderer(openDocument);
        this.renderer.setPaintMaxResolution(true);
    }

    public void print() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        printerException.printStackTrace();
                    }
                }
            }
        });
        thread.setName("ODTDPrinter Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.renderer.getPrintedPagesNumber()) {
            return 1;
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this.renderer);
        repaintManager.setDoubleBufferingEnabled(false);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = this.renderer.getPrintWidth();
        double d2 = pageFormat.getImageableWidth();
        double d3 = d / d2;
        this.renderer.setIgnoreMargins(true);
        this.renderer.setResizeFactor(d3);
        this.renderer.setCurrentPage(n);
        this.renderer.paintComponent(graphics2D);
        return 0;
    }
}

